/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ImageImporter;
import classes.MapGen;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class TileGrabber
extends JFrame {
    MapGen pix;
    FileDialog dialog;
    ImageImporter importer = new ImageImporter();
    String infoname = "";
    int lastNumber;
    int lastposX;
    int lastposY;
    int lastW;
    int lastH;
    String lastname = "";
    private JCheckBox add;
    private JCheckBox begin;
    private JTextField height;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JTextField number;
    private JTextField number1;
    private JTextField number2;
    private JButton posDown;
    private JButton posDown1;
    private JButton posLeft;
    private JButton posLeft1;
    private JButton posRight;
    private JButton posRight1;
    private JButton posRight2;
    private JButton posRight3;
    private JButton posRight4;
    private JButton posUp;
    private JButton posUp1;
    private JTextField posx;
    private JTextField posy;
    private JTextField split;
    private JButton splitm;
    private JButton splitp;
    private JTextField width;

    public TileGrabber(MapGen pv) {
        this.initComponents();
        this.pix = pv;
    }

    protected void Import() {
        File a;
        if (this.dialog == null) {
            this.dialog = new FileDialog((Frame)this, "Import image", 0);
        }
        if (this.pix == null) {
            return;
        }
        this.dialog.setVisible(true);
        String path = this.dialog.getDirectory();
        String file = this.dialog.getFile();
        if (path != null && file != null && (a = new File(path + file)).exists()) {
            String gname = path + file;
            gname = gname + ".tile.inf";
            File b = new File(gname);
            this.infoname = gname;
            if (b.exists()) {
                this.importInfo(b);
            }
            byte[] data = new byte[(int)a.length()];
            try {
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                bin.read(data);
                bin.close();
                this.pix.image = this.importer.readImage(data, path + file);
                this.pix.draw();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void importInfo(File a) {
        try {
            String info = "";
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
            byte[] data = new byte[(int)a.length()];
            bin.read(data);
            bin.close();
            for (int i = 0; i < data.length; ++i) {
                info = info + (char)(data[i] & 0xFF);
            }
            String[] inf = info.split("\r\n");
            int off = 0;
            this.width.setText(inf[off++]);
            this.height.setText(inf[off++]);
            this.split.setText(inf[off++]);
            this.number1.setText(inf[off++]);
            this.number2.setText(inf[off++]);
            this.number.setText(inf[off++]);
            this.posx.setText(inf[off++]);
            this.posy.setText(inf[off++]);
            this.begin.setSelected(inf[off++].equals("zero"));
            this.add.setSelected(inf[off++].equals("addblank"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void exportInfo() {
        File a = new File(this.infoname);
        String info = "";
        info = info + this.getSprWidth() + "\r\n";
        info = info + this.getSprWidth() + "\r\n";
        info = info + this.getSplit() + "\r\n";
        info = info + this.getGapX() + "\r\n";
        info = info + this.getGapY() + "\r\n";
        info = info + this.getNumber() + "\r\n";
        info = info + this.getPosX() + "\r\n";
        info = info + this.getPosY() + "\r\n";
        info = info + (this.getBeginZero() ? "zero" : "not") + "\r\n";
        info = info + (this.getAddBlank() ? "addblank" : "not") + "\r\n";
        System.out.println("Export: " + this.infoname + "\r\n" + info);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(a));
            bos.write(info.getBytes("UTF-8"));
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNumber(int nr) {
        this.number.setText("" + nr);
    }

    public int getGapX() {
        return Integer.parseInt(this.number1.getText());
    }

    public int getGapY() {
        return Integer.parseInt(this.number2.getText());
    }

    public void resetGap() {
        this.number1.setText("0");
        this.number2.setText("0");
        this.split.setText("0");
        this.posx.setText("0");
        this.posy.setText("0");
    }

    public boolean getBeginZero() {
        return this.begin.isSelected();
    }

    public boolean getAddBlank() {
        return this.add.isSelected();
    }

    public int getNumber() {
        try {
            this.lastNumber = Integer.parseInt(this.number.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastNumber;
    }

    public int getSplit() {
        return Integer.parseInt(this.split.getText());
    }

    public int getPosX() {
        try {
            int x;
            this.lastposX = x = Integer.parseInt(this.posx.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastposX;
    }

    public int getPosY() {
        try {
            int y;
            this.lastposY = y = Integer.parseInt(this.posy.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastposY;
    }

    public int getSprWidth() {
        try {
            int w;
            this.lastW = w = Integer.parseInt(this.width.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastW;
    }

    public int getSprHeight() {
        try {
            int w;
            this.lastH = w = Integer.parseInt(this.height.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastH;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.posUp = new JButton();
        this.posDown = new JButton();
        this.posRight = new JButton();
        this.posLeft = new JButton();
        this.jLabel2 = new JLabel();
        this.posLeft1 = new JButton();
        this.posUp1 = new JButton();
        this.posDown1 = new JButton();
        this.posRight1 = new JButton();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.number = new JTextField();
        this.posRight2 = new JButton();
        this.jButton2 = new JButton();
        this.posx = new JTextField();
        this.posy = new JTextField();
        this.width = new JTextField();
        this.height = new JTextField();
        this.jLabel4 = new JLabel();
        this.jButton3 = new JButton();
        this.number1 = new JTextField();
        this.posRight3 = new JButton();
        this.jLabel5 = new JLabel();
        this.jButton4 = new JButton();
        this.number2 = new JTextField();
        this.posRight4 = new JButton();
        this.begin = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.splitm = new JButton();
        this.split = new JTextField();
        this.splitp = new JButton();
        this.jButton5 = new JButton();
        this.add = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.setTitle("Tile Grabber");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.jLabel1.setText("Position:");
        this.posUp.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-up-1.png")));
        this.posUp.setFocusable(false);
        this.posUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posUpActionPerformed(evt);
            }
        });
        this.posDown.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-down-1.png")));
        this.posDown.setFocusable(false);
        this.posDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posDownActionPerformed(evt);
            }
        });
        this.posRight.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-right-5.png")));
        this.posRight.setFocusable(false);
        this.posRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posRightActionPerformed(evt);
            }
        });
        this.posLeft.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-left-5.png")));
        this.posLeft.setFocusable(false);
        this.posLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posLeftActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Size:");
        this.posLeft1.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-left-5.png")));
        this.posLeft1.setFocusable(false);
        this.posLeft1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posLeft1ActionPerformed(evt);
            }
        });
        this.posUp1.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-up-1.png")));
        this.posUp1.setFocusable(false);
        this.posUp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posUp1ActionPerformed(evt);
            }
        });
        this.posDown1.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-down-1.png")));
        this.posDown1.setFocusable(false);
        this.posDown1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posDown1ActionPerformed(evt);
            }
        });
        this.posRight1.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-right-5.png")));
        this.posRight1.setFocusable(false);
        this.posRight1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posRight1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Number:");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-left-5.png")));
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.jButton1ActionPerformed(evt);
            }
        });
        this.number.setColumns(2);
        this.number.setHorizontalAlignment(4);
        this.number.setText("1");
        this.number.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TileGrabber.this.numberKeyReleased(evt);
            }
        });
        this.posRight2.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-right-5.png")));
        this.posRight2.setFocusable(false);
        this.posRight2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posRight2ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Generate Tiles");
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.jButton2ActionPerformed(evt);
            }
        });
        this.posx.setColumns(2);
        this.posx.setHorizontalAlignment(4);
        this.posx.setText("0");
        this.posx.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TileGrabber.this.posxKeyReleased(evt);
            }
        });
        this.posy.setColumns(2);
        this.posy.setHorizontalAlignment(4);
        this.posy.setText("0");
        this.posy.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TileGrabber.this.posyKeyReleased(evt);
            }
        });
        this.width.setColumns(2);
        this.width.setHorizontalAlignment(4);
        this.width.setText("32");
        this.width.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TileGrabber.this.widthKeyReleased(evt);
            }
        });
        this.height.setColumns(2);
        this.height.setHorizontalAlignment(4);
        this.height.setText("32");
        this.height.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TileGrabber.this.heightKeyReleased(evt);
            }
        });
        this.jLabel4.setText("GAP X:");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-left-5.png")));
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.jButton3ActionPerformed(evt);
            }
        });
        this.number1.setColumns(2);
        this.number1.setHorizontalAlignment(4);
        this.number1.setText("0");
        this.number1.setFocusable(false);
        this.posRight3.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-right-5.png")));
        this.posRight3.setFocusable(false);
        this.posRight3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posRight3ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("GAP Y:");
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-left-5.png")));
        this.jButton4.setFocusable(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.jButton4ActionPerformed(evt);
            }
        });
        this.number2.setColumns(2);
        this.number2.setHorizontalAlignment(4);
        this.number2.setText("0");
        this.number2.setFocusable(false);
        this.posRight4.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-right-5.png")));
        this.posRight4.setFocusable(false);
        this.posRight4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.posRight4ActionPerformed(evt);
            }
        });
        this.begin.setText("Begin new Line at 0");
        this.begin.setFocusable(false);
        this.begin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.beginActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Split:");
        this.splitm.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-left-5.png")));
        this.splitm.setFocusable(false);
        this.splitm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.splitmActionPerformed(evt);
            }
        });
        this.split.setColumns(2);
        this.split.setHorizontalAlignment(4);
        this.split.setText("0");
        this.split.setFocusable(false);
        this.splitp.setIcon(new ImageIcon(this.getClass().getResource("/classes/0arrow-right-5.png")));
        this.splitp.setFocusable(false);
        this.splitp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.splitpActionPerformed(evt);
            }
        });
        this.jButton5.setText("Import tileset");
        this.jButton5.setFocusable(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.jButton5ActionPerformed(evt);
            }
        });
        this.add.setText("Add blank tile");
        this.add.setFocusable(false);
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.addActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Remove double tiles");
        this.jCheckBox1.setFocusable(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TileGrabber.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.posLeft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addComponent(this.posx).addGap(8, 8, 8))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.posDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.posRight)).addGroup(layout.createSequentialGroup().addComponent(this.posUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.posy)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -2, 41, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.number1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.posRight3)).addGroup(layout.createSequentialGroup().addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.number2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.posRight4)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.split, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitp)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.number, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.posRight2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.posLeft1, -1, -1, Short.MAX_VALUE).addComponent(this.width)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.posUp1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.height)).addGroup(layout.createSequentialGroup().addComponent(this.posDown1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.posRight1))))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.add).addComponent(this.begin).addComponent(this.jCheckBox1)))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.posUp).addComponent(this.posx, -2, -1, -2).addComponent(this.posy, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.posDown).addComponent(this.posRight).addComponent(this.posLeft))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.posUp1).addComponent(this.width, -2, -1, -2).addComponent(this.height, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.posDown1).addComponent(this.posRight1).addComponent(this.posLeft1)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jButton1).addComponent(this.number, -2, -1, -2).addComponent(this.posRight2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.splitm).addComponent(this.split, -2, -1, -2).addComponent(this.splitp).addComponent(this.begin)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jButton3).addComponent(this.number1, -2, -1, -2).addComponent(this.posRight3).addComponent(this.add)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jButton4).addComponent(this.number2, -2, -1, -2).addComponent(this.posRight4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int nr = Integer.parseInt(this.number.getText());
        if (nr > 1) {
            --nr;
        }
        this.number.setText(nr + "");
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void posRight2ActionPerformed(ActionEvent evt) {
        int nr = Integer.parseInt(this.number.getText());
        this.number.setText(++nr + "");
        try {
            if (this.pix != null) {
                this.pix.draw();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void posRightActionPerformed(ActionEvent evt) {
        int w;
        int x = this.getPosX();
        if (x * 2 + (w = this.getSprWidth()) * 2 < this.pix.image.getWidth()) {
            this.posx.setText("" + ++x);
            if (this.pix != null) {
                this.pix.draw();
            }
        }
    }

    private void posLeftActionPerformed(ActionEvent evt) {
        int x = this.getPosX();
        if (x > 0) {
            this.posx.setText("" + --x);
            if (this.pix != null) {
                this.pix.draw();
            }
        }
    }

    private void posUpActionPerformed(ActionEvent evt) {
        int y = this.getPosY();
        if (y > 0) {
            this.posy.setText("" + --y);
            if (this.pix != null) {
                this.pix.draw();
            }
        }
    }

    private void posDownActionPerformed(ActionEvent evt) {
        int h;
        int y = this.getPosY();
        if (y + (h = this.getSprHeight()) < this.pix.image.getHeight()) {
            this.posy.setText("" + ++y);
            if (this.pix != null) {
                this.pix.draw();
            }
        }
    }

    public void setPosX(int x) {
        this.posx.setText("" + x);
    }

    public void setPosY(int y) {
        this.posy.setText("" + y);
    }

    private void posUp1ActionPerformed(ActionEvent evt) {
        int h = this.getSprHeight();
        if (h > 1) {
            this.height.setText("" + --h);
            if (this.pix != null) {
                this.pix.draw();
            }
        }
    }

    private void posDown1ActionPerformed(ActionEvent evt) {
        int h = this.getSprHeight();
        if (h + this.getPosY() < this.pix.image.getHeight()) {
            this.height.setText("" + ++h);
            if (this.pix != null) {
                this.pix.draw();
            }
        }
    }

    private void posLeft1ActionPerformed(ActionEvent evt) {
        int w = this.getSprWidth();
        if (w > 1) {
            this.width.setText("" + --w);
            if (this.pix != null) {
                this.pix.draw();
            }
        }
    }

    private void posRight1ActionPerformed(ActionEvent evt) {
        int w = this.getSprWidth();
        if (w + this.getPosX() < this.pix.image.getWidth()) {
            this.width.setText("" + ++w);
            if (this.pix != null) {
                this.pix.draw();
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.exportInfo();
        this.pix.useBlank = this.getAddBlank();
        this.pix.doTiles();
        this.pix.draw();
        this.pix.drawMap(this.pix.zoomFactor);
        this.pix.setTileSize();
        this.setVisible(false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        int gapx = Integer.parseInt(this.number1.getText());
        if (gapx > 0) {
            --gapx;
        }
        this.number1.setText(gapx + "");
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void posRight3ActionPerformed(ActionEvent evt) {
        int gapx = Integer.parseInt(this.number1.getText());
        this.number1.setText(++gapx + "");
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        int gapy = Integer.parseInt(this.number2.getText());
        if (gapy > 0) {
            --gapy;
        }
        this.number2.setText(gapy + "");
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void posRight4ActionPerformed(ActionEvent evt) {
        int gapy = Integer.parseInt(this.number2.getText());
        this.number2.setText(++gapy + "");
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void beginActionPerformed(ActionEvent evt) {
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void posxKeyReleased(KeyEvent evt) {
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void posyKeyReleased(KeyEvent evt) {
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void widthKeyReleased(KeyEvent evt) {
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void heightKeyReleased(KeyEvent evt) {
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void splitmActionPerformed(ActionEvent evt) {
        int spl = Integer.parseInt(this.split.getText());
        if (spl > 0) {
            --spl;
        }
        this.split.setText(spl + "");
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void splitpActionPerformed(ActionEvent evt) {
        int spl = Integer.parseInt(this.split.getText());
        if (spl < this.getNumber() - 1) {
            ++spl;
        }
        this.split.setText(spl + "");
        if (this.pix != null) {
            this.pix.draw();
        }
    }

    private void numberKeyReleased(KeyEvent evt) {
        try {
            if (this.pix != null) {
                this.pix.draw();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.Import();
    }

    private void addActionPerformed(ActionEvent evt) {
        if (this.pix != null) {
            this.pix.useBlank = this.add.isSelected();
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.pix != null) {
            this.pix.removeDuplicate = this.jCheckBox1.isSelected();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TileGrabber.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(TileGrabber.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TileGrabber.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TileGrabber.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TileGrabber frame = new TileGrabber(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(3);
            }
        });
    }
}

